/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.requests;

import com.ibm.hwmca.base.rsf.requests.BaseRsfRequestErrorIds;
import com.ibm.hwmca.base.rsf.util.RsfHexadecimal;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.ProblemReportRequestBody;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import java.io.UnsupportedEncodingException;

public class SdPapRequestContent
implements BaseRsfRequestErrorIds {
    private static final String TRACE_MASKT = "XRSF   T";
    private static final String TRACE_MASKF = "XRSF   F";
    private static final String TRACE_MASKD = "XRSF   D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(94, "RsfRequest");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    ProblemReportRequestBody data;
    String customerContact;
    String customerNumber;
    String baseCustomerNumber;
    String cpn;
    String nsfiData;
    private static String EBCDIC = "Cp500";
    private static String COPYWRIT = "CCOOPPRR..  IIBBMM  11998844                            ";
    private static int neg = -256;

    public SdPapRequestContent(ProblemReportRequestBody data) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "->SdPapRequestContent::constructor");
        this.data = data;
        this.customerContact = data.getAttribute("Problem Customer contact");
        if (this.customerContact == null) {
            throw new IllegalArgumentException("Missing 'Problem Customer contact' attribute from data");
        }
        this.customerNumber = data.getAttribute("Customer number");
        if (this.customerNumber == null) {
            throw new IllegalArgumentException("Missing 'Customer number' attribute from data");
        }
        this.baseCustomerNumber = data.getAttribute("Base customer number");
        if (this.baseCustomerNumber == null) {
            throw new IllegalArgumentException("Missing 'Base customer number' attribute from data");
        }
        this.cpn = data.getAttribute("Problem Number");
        if (this.cpn == null) {
            throw new IllegalArgumentException("Missing 'Problem Number' attribute from data");
        }
        this.nsfiData = data.getAttribute("Detailed Data");
        if (this.nsfiData == null) {
            throw new IllegalArgumentException("Missing 'Detailed Data' attribute from data");
        }
        Trace.trace(TRACE_MASKT, "<-SdPapRequestContent::constructor");
    }

    public byte[] format(byte[] header) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "->SdPapRequestContent::format");
        if (header == null || header.length != 22) {
            throw new IllegalArgumentException("Invalid length of header for service director comfile");
        }
        byte[] comfile = new byte[747];
        comfile[0] = 2;
        comfile[1] = SdPapRequestContent.assignByte(235);
        comfile[2] = SdPapRequestContent.assignByte(129);
        comfile[4] = 0;
        comfile[5] = 2;
        comfile[6] = 0;
        for (int i = 0; i < 22; ++i) {
            comfile[i + 7] = header[i];
        }
        try {
            int i;
            int i2;
            int i3;
            comfile[29] = 3;
            RsfMachineInfo machInfo = this.data.getReportingMachineInfo();
            byte[] machType = machInfo.getMachineType().substring(0, 4).getBytes(EBCDIC);
            for (int i4 = 0; i4 < 4; ++i4) {
                comfile[i4 + 30] = machType[i4];
                comfile[i4 + 45] = machType[i4];
            }
            byte[] machModel = machInfo.getMachineModel().substring(0, 3).getBytes(EBCDIC);
            for (int i5 = 0; i5 < 3; ++i5) {
                comfile[i5 + 35] = machModel[i5];
                comfile[i5 + 50] = machModel[i5];
            }
            String machSer = machInfo.getMachineSerial();
            String serial = machSer.substring(3, 5) + machSer.substring(7, 12);
            byte[] machSerial = serial.getBytes(EBCDIC);
            for (int i6 = 0; i6 < 7; ++i6) {
                comfile[i6 + 38] = machSerial[i6];
                comfile[i6 + 53] = machSerial[i6];
            }
            comfile[66] = 1;
            comfile[67] = 8;
            comfile[68] = 0;
            comfile[69] = 64;
            comfile[73] = SdPapRequestContent.assignByte(128);
            byte[] blank = new String(" ").getBytes(EBCDIC);
            for (int i7 = 102; i7 < 129; ++i7) {
                comfile[i7] = blank[0];
            }
            byte[] custcon = this.customerContact.getBytes(EBCDIC);
            int lCustcon = Math.min(custcon.length, 36);
            byte[] custphon = this.customerNumber.getBytes(EBCDIC);
            int lCustphon = Math.min(custphon.length, 30);
            byte[] servphon = this.baseCustomerNumber.getBytes(EBCDIC);
            int lServphon = Math.min(servphon.length, 30);
            for (i3 = 0; i3 < lCustcon; ++i3) {
                comfile[i3 + 207] = custcon[i3];
            }
            for (i3 = lCustcon; i3 < 36; ++i3) {
                comfile[i3 + 207] = blank[0];
            }
            for (i3 = 0; i3 < lCustphon; ++i3) {
                comfile[i3 + 243] = custphon[i3];
            }
            for (i3 = lCustphon; i3 < 30; ++i3) {
                comfile[i3 + 243] = blank[0];
            }
            for (i3 = 0; i3 < lServphon; ++i3) {
                comfile[i3 + 273] = servphon[i3];
            }
            for (i3 = lServphon; i3 < 30; ++i3) {
                comfile[i3 + 273] = blank[0];
            }
            byte[] copyWrite = COPYWRIT.getBytes(EBCDIC);
            for (int i8 = 0; i8 < copyWrite.length; ++i8) {
                comfile[i8 + 333] = copyWrite[i8];
            }
            byte[] prob_num = this.cpn.getBytes(EBCDIC);
            int lProb_num = Math.min(prob_num.length, 4);
            for (i2 = 0; i2 < lProb_num; ++i2) {
                comfile[i2 + 389] = copyWrite[i2];
            }
            for (i2 = 394; i2 < 458; ++i2) {
                comfile[i2] = blank[0];
            }
            byte[] ectab = this.nsfiData.getBytes(EBCDIC);
            int lEctab = Math.min(ectab.length, 288);
            for (i = 0; i < lEctab; ++i) {
                comfile[i + 459] = ectab[i];
            }
            for (i = lEctab; i < 288; ++i) {
                comfile[i + 459] = blank[0];
            }
            comfile[501] = 3;
            comfile[597] = 3;
            comfile[693] = 3;
        }
        catch (UnsupportedEncodingException e) {
            Trace.trace(TRACE_MASKF, "SdPapRequestContent.format: Unsupported Encoding Exception");
            new FrameworkLog(logInfo, 12546, e).log(infoLog);
        }
        Trace.trace(TRACE_MASKD, "Service Director Pap comfile:");
        Trace.trace(TRACE_MASKD, this.dumpComfile(comfile));
        return comfile;
    }

    public String dumpComfile(byte[] data) {
        if (data.length < 747) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 715; i += 32) {
            for (int j = 0; j < 8; ++j) {
                buffer.append(RsfHexadecimal.buildHexadecimalString(data, i + j * 4, 4) + " ");
            }
            buffer.append('\n');
        }
        buffer.append(RsfHexadecimal.buildHexadecimalString(data, 735, 4) + " ");
        buffer.append(RsfHexadecimal.buildHexadecimalString(data, 739, 4) + " ");
        buffer.append(RsfHexadecimal.buildHexadecimalString(data, 743, 3) + "\n");
        return buffer.toString();
    }

    public static byte assignByte(int i) {
        if (i <= 127) {
            return (byte)i;
        }
        return (byte)(i | neg);
    }
}

